﻿using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class MapToPatGetConsultsRequestStep : FilterBase<GetConsultsForPatientStateObject>
    {
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            if (!state.IsHomeMobile && state.PatientStationCode != state.ProviderStationCode)
            {
                state.PatEcRequest = new GetConsultsforPatientMapper().mapGetConsultRequest(state, Side.Patient, Logger.Instance);
                if (state.PatEcRequest != null)
                {
                    var siteNum = state.PatEcRequest.VIMTVIAEMRgcfpReqqueryBeanInfo.VIMTVIAEMRgcfpReqpatientInfo.mcs_localSiteId;
                    if (string.IsNullOrEmpty(state.PatUserDuz))
                        state.PatLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy, state.SamlToken);
                    else
                        state.PatEcRequest.VIMTVIAEMRgcfpReqqueryBeanInfo.VIMTVIAEMRgcfpReqproviderInfo.mcs_userId = state.PatUserDuz;
                }
            }
            else
            {
                Logger.Instance.Debug("skipping Patient Side for ViaGetConsults.");
            }
        }
    }
}